/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package teamdev.jxcapture.samples.demo;

import javax.swing.*;
import javax.swing.plaf.BorderUIResource;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.net.URL;

/**
 * @author Ikryanov Vladimir
 */
public class AboutDialog extends EscapeDialog {

    private static AboutDialog instance;

    private ResourceBundle resource = ApplicationSettings.getResourceBundle();

    private AboutDialog() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add(createContentPane(), BorderLayout.CENTER);
        contentPane.add(createActionPane(), BorderLayout.SOUTH);
        setContentPane(contentPane);

        setTitle(resource.getString("AboutDialog.Title"));
        setSize(424, 360);
        setLocationRelativeTo(null);
        setResizable(false);
    }

    public static AboutDialog getInstance() {
        return instance == null ? instance = new AboutDialog() : instance;
    }

    private Component createActionPane() {
        JButton closeButton = new JButton(new CloseDialogAction());
        closeButton.setPreferredSize(new Dimension(75, 23));
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add(new JSeparator(), new GridBagConstraints(
                0, 0, 2, 1, 1.0, 0.0, GridBagConstraints.NORTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add(Box.createHorizontalGlue(), new GridBagConstraints(
                0, 1, 1, 1, 1.0, 0.0, GridBagConstraints.NORTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add(closeButton, new GridBagConstraints(
                1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(8, 8, 8, 8), 0, 0));
        return contentPane;
    }

    private Component createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add(createLogoPane(), BorderLayout.WEST);
        contentPane.add(createInfoPane(), BorderLayout.CENTER);
        return contentPane;
    }

    private Component createLogoPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBackground(Color.WHITE);
        contentPane.setBorder(new BorderUIResource.EmptyBorderUIResource(4, 4, 4, 4));
        URL imageURL = getClass().getResource(resource.getString("AboutDialog.Icon.About"));
        JLabel aboutLabel = new JLabel(new ImageIcon(imageURL));
        contentPane.add(aboutLabel, BorderLayout.CENTER);
        return contentPane;
    }

    private Component createInfoPane() {
        JLabel copyrightCompany = new JLabel(resource.getString("AboutDialog.Label.Company.Text"));
        JLabel copyrightProduct = new JLabel(resource.getString("AboutDialog.Label.Product.Text"));

        String url = resource.getString("AboutDialog.HTMLLabel.URL");
        String text = resource.getString("AboutDialog.HTMLLabel.Text");
        HTMLLabel companyLink = new HTMLLabel(text, url);
        companyLink.setToolTipText(url);

        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(new BorderUIResource.EmptyBorderUIResource(4, 4, 4, 4));
        contentPane.setBackground(Color.WHITE);
        contentPane.add(createProductNamePane(), new GridBagConstraints(
                0, 0, 1, 1, 1.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.SOUTH, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add(Box.createVerticalGlue(), new GridBagConstraints(
                0, 1, 1, 1, 0.0, 1.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.SOUTH, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add(companyLink, new GridBagConstraints(
                0, 2, 1, 1, 1.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 4, 4, 0), 0, 0));
        contentPane.add(copyrightCompany, new GridBagConstraints(
                0, 3, 1, 1, 1.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(4, 4, 0, 0), 0, 0));
        contentPane.add(copyrightProduct, new GridBagConstraints(
                0, 4, 1, 1, 1.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 4, 0, 0), 0, 0));
        return contentPane;
    }

    private Component createProductNamePane() {
        URL imageURL = getClass().getResource(resource.getString("AboutDialog.Icon.Logo"));
        JLabel logoLabel = new JLabel(new ImageIcon(imageURL));

        JLabel versionLabel = new JLabel(resource.getString("AboutDialog.Label.Version.Text"));
        versionLabel.setForeground(Color.GRAY);
        versionLabel.setBorder(new BorderUIResource.EmptyBorderUIResource(0, 112, 0, 0));

        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(false);
        contentPane.setBorder(new BorderUIResource.EmptyBorderUIResource(15, 0, 0, 0));
        contentPane.add(logoLabel, BorderLayout.WEST);
        contentPane.add(versionLabel, BorderLayout.SOUTH);
        return contentPane;
    }

    private class HTMLLabel extends JLabel {

        private String url;

        private Color mouseEnteredColor;
        private Color mouseExitedColor;

        private boolean mouseEntered;

        private HTMLLabelMouseListener mouseListener = new HTMLLabelMouseListener();

        public HTMLLabel(String text, String url) {
            this(text, url, Color.BLUE, Color.BLUE);
        }

        public HTMLLabel(String text, String url, Color mouseEnteredColor, Color mouseExitedColor) {
            this.url = url;
            this.mouseEnteredColor = mouseEnteredColor;
            this.mouseExitedColor = mouseExitedColor;

            setText(text);
            setCursor(new Cursor(Cursor.HAND_CURSOR));
            setForeground(mouseExitedColor);

            addMouseListener(mouseListener);
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (isEnabled() && mouseEntered) {
                g.drawLine(0, getHeight() - 1, (int) getPreferredSize().getWidth(), getHeight() - 1);
            }
        }

        public void dispose() {
            removeMouseListener(mouseListener);
        }

        private class HTMLLabelMouseListener extends MouseAdapter {

            public void mouseClicked(MouseEvent event) {
                try {
                    Runtime.getRuntime().exec("cmd /c start " + url);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void mouseEntered(MouseEvent e) {
                setForeground(mouseEnteredColor);
                mouseEntered = true;
                repaint();
            }

            public void mouseExited(MouseEvent e) {
                setForeground(mouseExitedColor);
                mouseEntered = false;
                repaint();
            }
        }
    }

    private class CloseDialogAction extends AbstractAction {
        private CloseDialogAction() {
            putValue(AbstractAction.NAME, resource.getString("AboutDialog.Action.Close.Text"));
        }

        public void actionPerformed(ActionEvent e) {
            setVisible(false);
        }
    }
}
